<?php
include 'usuarios_crud.php';
include 'encripta.php';
$usuariosPorPagina = 10;
$paginaActual = isset($_GET['pagina']) ? $_GET['pagina'] : 1;
$busqueda = isset($_GET['busqueda']) ? $_GET['busqueda'] : '';

$inicio = ($paginaActual - 1) * $usuariosPorPagina;
$usuarios = obtenerUsuariosPaginados($inicio, $usuariosPorPagina, $busqueda);

$totalUsuarios = obtenerTotalUsuarios($busqueda );

$totalPaginas = ceil($totalUsuarios / $usuariosPorPagina);

$output = array(
  'usuarios' => '', // Aquí se insertarán los usuarios en el HTML
  'paginacion' => '' // Aquí se insertará la paginación en el HTML
);

if ($usuarios) {
  foreach ($usuarios as $usuario) {


    $usuario_encr=encriptarId($usuario['id_usuario']);
    $output['usuarios'] .= '<tr>';
    $output['usuarios'] .= '<td>' . $usuario['id_usuario'] . '</td>';
    $output['usuarios'] .= '<td>' . $usuario['correo'] . '</td>';
    $output['usuarios'] .= '<td>' . $usuario['nombres'] . '</td>';
    $output['usuarios'] .= '<td>' . $usuario['apellidos'] . '</td>';
    $output['usuarios'] .= '<td>' . $usuario['rut'] . '</td>';
    $output['usuarios'] .= '<td>' . $usuario['perfil'] . '</td>';
    $output['usuarios'] .= '<td><div class="custom-control custom-switch">';
    $output['usuarios'] .= '<input type="checkbox" class="custom-control-input chk-estado" id="switch-' . $usuario['id_usuario']. '" data-id="' . $usuario_encr . '" ' . ($usuario['activo'] == 1 ? 'checked' : '') . '>';
    $output['usuarios'] .= '<label class="custom-control-label" for="switch-' . $usuario['id_usuario'] . '"></label>';
    $output['usuarios'] .= '</div></td>';
    // Agregar botones de acciones (editar, contraseña)
     $output['usuarios'] .= '<td><button class="btn btn-warning btn-editar" data-id="' . encriptarId($usuario['id_usuario']) . '"><i class="fas fa-edit"></i></button></td>';   
     $output['usuarios'] .= '<td><button class="btn btn-info btn-cambiar-contrasena" data-id="' . encriptarId($usuario['id_usuario']) . '"><i class="fas fa-key"></i></button></td>';
    $output['usuarios'] .= '</tr>';
  }
}

if ($totalPaginas > 1) {
    $output['paginacion'] .= '<ul class="pagination pagination-sm m-0 float-right">';

    // Botón Ir Atrás
    $output['paginacion'] .= '<li class="page-item' . ($paginaActual == 1 ? ' disabled' : '') . '" data-pagina="' . ($paginaActual - 1) . '"><a class="page-link" href="#">Anterior</a></li>';

    // Numeración de páginas
    $maxPaginasMostrar = 10;
    $mitadPaginas = floor($maxPaginasMostrar / 2);

    if ($totalPaginas <= $maxPaginasMostrar) {
        for ($i = 1; $i <= $totalPaginas; $i++) {
            $output['paginacion'] .= '<li class="page-item' . ($i == $paginaActual ? ' active' : '') . '" data-pagina="' . $i . '"><a class="page-link" href="#">' . $i . '</a></li>';
        }
    } else {
        $inicioMostrar = max(1, $paginaActual - $mitadPaginas);
        $finMostrar = min($totalPaginas, $inicioMostrar + $maxPaginasMostrar - 1);

        if ($finMostrar - $inicioMostrar < $maxPaginasMostrar - 1) {
            $inicioMostrar = max(1, $finMostrar - $maxPaginasMostrar + 1);
        }

        if ($finMostrar - $inicioMostrar < $maxPaginasMostrar - 1) {
            $finMostrar = min($totalPaginas, $inicioMostrar + $maxPaginasMostrar - 1);
        }

        for ($i = $inicioMostrar; $i <= $finMostrar; $i++) {
            $output['paginacion'] .= '<li class="page-item' . ($i == $paginaActual ? ' active' : '') . '" data-pagina="' . $i . '"><a class="page-link" href="#">' . $i . '</a></li>';
        }
    }

    // Botón Ir Adelante
    $output['paginacion'] .= '<li class="page-item' . ($paginaActual == $totalPaginas ? ' disabled' : '') . '" data-pagina="' . ($paginaActual + 1) . '"><a class="page-link" href="#">Siguiente</a></li>';

    $output['paginacion'] .= '</ul>';
}


header('Content-Type: application/json');
echo json_encode($output);
?>
