<?php
// Archivo: obtener_categorias.php

// Incluir el archivo de conexión a la base de datos
include('db.php');

// Consulta SQL para obtener las categorías
$sql = "SELECT categoria_id, descripcion FROM Categorias";

// Ejecutar la consulta
$resultado = $conn->query($sql);

// Verificar si hay filas de resultado
if ($resultado->num_rows > 0) {
    // Crear un array para almacenar las categorías
    $categorias = array();
    // Iterar sobre los resultados y agregar cada categoría al array
    while ($fila = $resultado->fetch_assoc()) {
        $categorias[] = array(
            'id' => $fila['categoria_id'],
            'descripcion' => utf8_encode($fila['descripcion'])
        );
      
    }
    // Devolver los datos en formato JSON
    echo json_encode($categorias);
   
} else {
    // Si no hay categorías, devolver un array vacío
    echo json_encode(array());
}

// Cerrar la conexión a la base de datos
$conn->close();
?>
