<!DOCTYPE html>
 <meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<?php
session_start();

// Verifica si la variable de sesión 'usuario_id' está establecida
if (isset($_SESSION['usuario_id'])) {
    // La sesión está activa, puedes acceder a las variables de sesión
    $usuarioId = $_SESSION['usuario_id'];
    $correo = $_SESSION['correo'];
    $nombres = $_SESSION['nombres'];
    $apellidos = $_SESSION['apellidos'];

    // Tu lógica aquí para usuarios autenticados

} else {
    // La sesión no está activa, redirige a la página de inicio de sesión u otra acción
    header('Location: login.php'); // Cambia 'iniciar_sesion.php' por la página de inicio de sesión
    exit(); // Asegúrate de detener la ejecución del script después de redirigir
}da
?>

<?php

include('includes/db.php');
include('includes/encripta.php');

$sql = "SELECT p.codigo,p.cantidad, t.descripcion as tipo, c.descripcion AS color, cat.descripcion AS categoria, m.descripcion AS marca, e.descripcion AS estilo, p.medidas, p.modelo, mat.descripcion AS material, p.precio_compra, p.proveedor, d.tipo_documento AS documento, p.precio_venta, p.num_documento, p.observacion
        FROM Productos p
        INNER JOIN Colores c ON p.color_id = c.color_id
        INNER JOIN Tipos t ON p.tipo_id = t.tipo_id
        INNER JOIN Categorias cat ON p.categoria_id = cat.categoria_id
        INNER JOIN Marcas m ON p.marca_id = m.marca_id
        INNER JOIN Estilos e ON p.estilo_id = e.estilo_id
        INNER JOIN Materiales mat ON p.material_id = mat.material_id
        INNER JOIN Documentos d ON p.documento_id = d.documento_id";
    $result = $conn->query($sql);

?>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Inventario de Armazones</title>
  <!-- Estilos de AdminLTE -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.1.0/css/adminlte.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css"  crossorigin="anonymous">
  <!-- Estilos de DataTables -->
  <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.css">


</head>
<body class="hold-transition sidebar-mini layout-fixed">

<div class="wrapper">

  <!-- Navbar -->
  <nav class="main-header navbar navbar-expand navbar-white navbar-light">
    <!-- Navbar links -->
    <ul class="navbar-nav">
      <li class="nav-item">
        <a class="nav-link" data-widget="pushmenu" href="#"><i class="fas fa-bars"></i></a>
      </li>
    </ul>
  </nav>c
  <!-- /.navbar -->

  <!-- Main Sidebar Container -->
  <aside class="main-sidebar sidebar-dark-primary elevation-4">
    <!-- Sidebar -->
    <div class="sidebar">
      <!-- Sidebar Menu -->
      <nav class="mt-2">
        <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
          <li class="nav-item">
            <a href="#" class="nav-link active">
              <i class="nav-icon fas fa-glasses"></i>
              <p>Armazones</p>
            </a>
          </li>
        </ul>
      </nav>
      <!-- /.sidebar-menu -->
    </div>
    <!-- /.sidebar -->
  </aside>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
	  <h1 class="m-0">Inventario de Armazones</h1>
        <div class="row mb-2">
          <div class="col-sm-6">  
			<button id="exportToExcel" class="btn btn-success">
				<i class="far fa-file-excel"></i> Exportar a Excel
			</button>

          </div><!-- /.col -->
		  <div class="col-sm-6 text-right">
			<button id="nuevo" class="btn btn-success" data-toggle="modal" data-target="#nuevoModal">
				<i class="fas fa-sort-numeric-up-circle"></i> Agregar nuevo producto
			</button>
		</div><!-- /.col -->

        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <!-- Tabla de inventario de armazones -->
        <div class="row">
          <div class="col-md-12">
            <div class="card">
              <div class="card-body table-responsive p-0">
                <table id="tablaArmazones" class="table table-hover">
                  <thead>
                        <tr>
                        <th scope="col">acciones</th>
                          <th scope="col">Código</th>
                          <th scope="col">Cantidad</th>
                          <th scope="col">Tipo</th>
                          <th scope="col">Color</th>
                          <th scope="col">Categoría</th>
                          <th scope="col">Marca</th>
                          <th scope="col">Estilo</th>
                          <th scope="col">Medidas</th>
                          <th scope="col">Modelo</th>
                          <th scope="col">Material</th>
                          <th scope="col">Precio Compra</th>
                          <th scope="col">Proveedor</th>
                          <th scope="col">Doc</th>
                          <th scope="col">Precio Venta</th>
                          <th scope="col">N° Doc</th>
                          <th scope="col">Observación</th>
                          
                        </tr>
                      </thead>
                  <tbody>
                    <!-- Datos de ejemplo -->
                      <?php
                    if ($result->num_rows > 0) {
                            while ($row = $result->fetch_assoc()) {
                                // Imprimir datos en la tabla HTML
                                echo "<tr>";
                                 echo '<td class="d-flex justify-content-between">';
                                  echo '<button class="btn btn-primary" data-toggle="modal" data-target="#editarModal" title="Modificar" 
                                            data-id="' . encriptarId($row['codigo'] ) . '" 
                                            data-codigo="' . $row['codigo']  . '" 
                                            data-codigo="' . $row['cantidad']  . '" 
                                            data-tipo="' . $row['tipo']. '" 
                                            data-color="' . $row['color'] . '"
                                            data-categoria="' . $row['categoria']. '"
                                            data-marca="' . $row['marca']. '"
                                            data-estilo="' .$row['estilo'] . '"
                                            data-medidas="' . $row['medidas'] . '"
                                            data-modelo="' .$row['modelo'] . '"
                                            data-material="' . $row['material'] . '"
                                            data-precio_compra="' .$row['precio_compra'] . '"
                                            data-proveedor="' .$row['proveedor'] . '"
                                            data-documento="' .$row['documento'] . '"
                                            data-precio_venta="' . $row['precio_venta'] . '"
                                            data-num_documento="' . $row['num_documento'] . '"
                                            data-observacion="' . $row['observacion']  . '">';
                                    echo '<i class="fas fa-edit"></i>';
                                
                                echo '</button>';
                                echo '<button class="btn btn-info" data-toggle="modal" data-target="#historialModal" title="Ver Historial" data-id="' . encriptarId($row['codigo'] ) . '" >';
                                echo '<i class="fas fa-history"></i>';
                                echo '</button>';
                                echo '<button class="btn btn-success" data-toggle="modal" data-target="#agregarModal" title="Agregar" data-id="' . encriptarId($row['codigo'] ) . '" >';
                                echo '<i class="fas fa-sort-numeric-up"></i>';
                                echo '</button>';
                                echo "</td>";
                                echo "<td>" . $row['codigo'] . "</td>";
                                echo "<td>" . $row['cantidad'] . "</td>";
                                echo "<td>" . utf8_encode($row['tipo'] ). "</td>";
                                echo "<td>" . utf8_encode($row['color'] ). "</td>";
                                echo "<td>" . utf8_encode($row['categoria']) . "</td>";
                                echo "<td>" . utf8_encode($row['marca']) . "</td>";
                                echo "<td>" . utf8_encode($row['estilo']) . "</td>";
                                echo "<td>" . utf8_encode($row['medidas']) . "</td>";
                                echo "<td>" . utf8_encode($row['modelo']) . "</td>";
                                echo "<td>" . utf8_encode($row['material']) . "</td>";
                                echo "<td>" . $row['precio_compra'] . "</td>";
                                echo "<td>" . utf8_encode($row['proveedor']) . "</td>";
                                echo "<td>" . $row['documento'] . "</td>";
                                echo "<td>" . $row['precio_venta'] . "</td>";
                                echo "<td>" . $row['num_documento'] . "</td>";
                                echo "<td>" . utf8_encode($row['observacion']) . "</td>";
                               
                                echo "</tr>";
                            }
                        } else {
                            // Si no hay resultados
                            echo "<tr><td colspan='15'>No hay productos disponibles.</td></tr>";
                        }
                   ?>
                   
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
        <!-- /.Tabla de inventario de armazones -->
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
<!--MODALES-->
<!-- Modal para modificar cantidad -->
<div class="modal fade" id="agregarModal" tabindex="-1" role="dialog" aria-labelledby="agregarModalLabel${code}" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="agregarModalLabel${code}">Modificar Inventario</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <input type="hidden" id="registro_id">
      <div class="modal-body">
        <!-- Contenido del formulario para agregar un nuevo producto -->
        <div class="form-group">
          <label for="accion">Seleccione la acción:</label>
          <select class="form-control" id="accion">
            <option value="">Seleccionar una acción</option>
            <option value="disminuir">Disminuir cantidad</option>
            <option value="aumentar">Aumentar cantidad</option>
          </select>
        </div>
        <!-- Opción para disminuir cantidad con observación -->
        <div id="disminuirCantidadOption" style="display: none;">
          <div class="form-group">
            <label for="cantidadDisminuir">Cantidad a disminuir:</label>
            <div class="input-group">
              <div class="input-group-prepend">
                <button class="btn btn-outline-secondary" type="button" id="disminuirCantidad">-</button>
              </div>
              <input type="number" class="form-control" id="cantidadDisminuir" name="cantidadDisminuir" placeholder="Ingrese la cantidad" required>
            </div>
          </div>
          <div class="form-group">
            <label for="observacionDisminuir">Observación:</label>
            <textarea class="form-control" id="observacionDisminuir" name="observacionDisminuir" placeholder="Ingrese una observación" required></textarea>
          </div>
        </div>
        <!-- Opción para aumentar cantidad con proveedor, documento, número y observación -->
        <div id="aumentarCantidadOption" style="display: none;">
          <div class="form-group">
            <label for="proveedor">Proveedor:</label>
            <input type="text" class="form-control" id="proveedor" name="proveedor" placeholder="Ingrese el proveedor">
          </div>
          <div class="form-group">
            <label for="documento">Documento:</label>
            <input type="text" class="form-control" id="documento" name="documento" placeholder="Ingrese el documento">
          </div>
          <div class="form-group">
            <label for="numero">Número:</label>
            <input type="text" class="form-control" id="numero" name="numero" placeholder="Ingrese el número">
          </div>
          <div class="form-group">
            <label for="cantidadAumentar">Cantidad a aumentar:</label>
            <div class="input-group">
              <div class="input-group-prepend">
                <button class="btn btn-outline-secondary" type="button" id="aumentarCantidad">+</button>
              </div>
              <input type="number" class="form-control" id="cantidadAumentar" name="cantidadAumentar" placeholder="Ingrese la cantidad" required>
            </div>
          </div>
          <div class="form-group">
            <label for="observacionAumentar">Observación:</label>
            <textarea class="form-control" id="observacionAumentar" name="observacionAumentar" placeholder="Ingrese una observación" required></textarea>
          </div>
        </div>
        <!-- Agrega los demás campos según sea necesario -->
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
        <button type="button" class="btn btn-primary" id="btnAgregarProducto">Agregar Producto</button>
      </div>
    </div>
  </div>
</div>






<!-- Modal para nuevo producto -->
<div class="modal fade" id="nuevoModal" tabindex="-1" role="dialog" aria-labelledby="nuevoModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document"> <!-- Clase modal-lg para hacerlo más ancho -->
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="editarModalLabel">Nuevo Producto</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
          <div class="row">
              
          
        	    <div class="col-md-4">
        	   <div class="form-group">
                      <label for="codigo">Código:</label>
                      <input type="text" class="form-control" id="codigo_n" name="codigo" placeholder="Ingrese el código" >
                    </div>
        		</div>
        	
        	
              
          
        	    <div class="col-md-4">
        	   <div class="form-group">
                      <label for="Cantidad">Cantidad:</label>
                      <input type="number" class="form-control" id="cantidad_n" name="cantidad" placeholder="Ingrese la cantidad" >
                    </div>
        		</div>
        </div>
        	
        <div class="row">
		
          <div class="col-md-4">
            <!-- Columna izquierda -->
           
            <div class="form-group">
              <label for="optico_sol">Tipo:</label>
              <select class="form-control" id="tipos_n" name="optico_sol">
        
              </select>
            </div>
	  
			 <div class="form-group">
              <label for="color">Color:</label>
              <select class="form-control" id="color_n" name="color">
        
              </select>
                </div>
           <div class="form-group">
			    <label for="material">Categoria:</label>
                <select class="form-control" id="categoria_n" name="optico_sol">
                </select>
			</div>
	
           
          </div>
          <div class="col-md-4">
            <!-- Columna del medio -->
			 <div class="form-group">
              <label for="marca">Marca:</label>
              <select class="form-control" id="marcas_n" name="marca">
        
              </select>
              </div>
			<div class="form-group">
              <label for="estilo">Estilo:</label>
              <select class="form-control" id="estilos_n" name="estilo">
        
              </select>
              </div>
            <div class="form-group">
              <label for="medidas">Medidas:</label>
              <input type="text" class="form-control" id="medidas_n" name="medidas" placeholder="Ingrese las medidas">
            </div>
          
           
         
         
			
            
          </div>
          <div class="col-md-4">
            <!-- Columna derecha -->
			 <div class="form-group">
              <label for="modelo">Modelo:</label>
              <input type="text" class="form-control" id="modelo_n" name="modelo" placeholder="Ingrese el modelo">
            </div>
			<div class="form-group">
              <label for="estilo">Material:</label>
              <select class="form-control" id="materiales_n" name="material">
        
              </select>
              </div>
            
			 
            <!-- Puedes agregar más campos aquí según sea necesario -->
          </div>
        </div>
           <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                      <label for="precio_compra">Precio Compra:</label>
                      <input type="number" class="form-control" id="precio_compra_n" name="precio_compra" placeholder="Ingrese el precio de compra">
                    </div>
                    
        			 
                   
             
			
               </div>
               <div class="col-md-6">
                   
                      <div class="form-group">
                      <label for="precio_venta">Precio Venta:</label>
                      <input type="number" class="form-control" id="precio_venta_n" name="precio_venta" placeholder="Ingrese el precio de venta">
                    </div>
                
                </div>
                
            </div>
            <div class="row">
                    <div class="col-md-4">
                     <div class="form-group">
                      <label for="proveedor">Proveedor:</label>
                      <input type="text" class="form-control" id="proveedor_n" name="proveedor" placeholder="Ingrese Nombre Proveedor">
                    </div>
        			 
               </div>
               <div class="col-md-4">
                    <div class="form-group">
                        <label for="documento">Seleccione Documento:</label>
                        <select class="form-control" id="documentos_n" name="documento">
                        </select>
                    </div>
                
                </div>
                <div class="col-md-4">
                      <div class="form-group">
                      <label for="precio_venta">Numero:</label>
                      <input type="number" class="form-control" id="num_doc_n" name="num_doc" placeholder="Ingrese Número Documento">
                    </div>
                </div>
            </div>
		 <div class="form-group">
          <label for="observacion">Observación:</label>
          <textarea class="form-control" id="observacion_n" name="observacion_n" placeholder="Ingrese una observación" required></textarea>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
        <button type="button" class="btn btn-primary" id="guardarBtn"> Guardar</button>
      </div>
    </div>
  </div>
</div>
<!-- Modal para modificar -->

<div class="modal fade" id="editarModal" tabindex="-1" role="dialog" aria-labelledby="nuevoModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document"> <!-- Clase modal-lg para hacerlo más ancho -->
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="editarModalLabel">Modificar Producto</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
	    <div class="col-md-4">
	   <div class="form-group">
              <label for="codigo">Código:</label>
              <input type="text" class="form-control" id="codigo_u" name="codigo" readonly >
            </div>
		</div>
		<input type="hidden" id="registro_id">
        <div class="row">
		
          <div class="col-md-4">
            <!-- Columna izquierda -->
           
            <div class="form-group">
              <label for="optico_sol">Tipo:</label>
              <select class="form-control" id="tipos_u" name="optico_sol">
        
              </select>
            </div>
	  
			 <div class="form-group">
              <label for="color">Color:</label>
              <select class="form-control" id="color_u" name="color">
        
              </select>
                </div>
           <div class="form-group">
			    <label for="material">Categoria:</label>
                <select class="form-control" id="categoria_u" name="optico_sol">
                </select>
			</div>
	
           
          </div>
          <div class="col-md-4">
            <!-- Columna del medio -->
			 <div class="form-group">
              <label for="marca">Marca:</label>
              <select class="form-control" id="marcas_u" name="marca">
        
              </select>
              </div>
			<div class="form-group">
              <label for="estilo">Estilo:</label>
              <select class="form-control" id="estilos_u" name="estilo">
        
              </select>
              </div>
            <div class="form-group">
              <label for="medidas">Medidas:</label>
              <input type="text" class="form-control" id="medidas_u" name="medidas" placeholder="Ingrese las medidas">
            </div>
          
           
         
         
			
            
          </div>
          <div class="col-md-4">
            <!-- Columna derecha -->
			 <div class="form-group">
              <label for="modelo">Modelo:</label>
              <input type="text" class="form-control" id="modelo_u" name="modelo" placeholder="Ingrese el modelo">
            </div>
			<div class="form-group">
              <label for="estilo">Material:</label>
              <select class="form-control" id="materiales_u" name="material">
        
              </select>
              </div>
            
			 
            <!-- Puedes agregar más campos aquí según sea necesario -->
          </div>
        </div>
           <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                      <label for="precio_compra">Precio Compra:</label>
                      <input type="number" class="form-control" id="precio_compra_u" name="precio_compra" placeholder="Ingrese el precio de compra">
                    </div>
                    
        			 
                   
             
			
               </div>
               <div class="col-md-6">
                   
                      <div class="form-group">
                      <label for="precio_venta">Precio Venta:</label>
                      <input type="number" class="form-control" id="precio_venta_u" name="precio_venta" placeholder="Ingrese el precio de venta">
                    </div>
                
                </div>
                
            </div>
            <div class="row">
                    <div class="col-md-4">
                     <div class="form-group">
                      <label for="proveedor">Proveedor:</label>
                      <input type="text" class="form-control" id="proveedor_u" name="proveedor" placeholder="Ingrese Nombre Proveedor">
                    </div>
        			 
               </div>
               <div class="col-md-4">
                    <div class="form-group">
                        <label for="documento">Seleccione Documento:</label>
                        <select class="form-control" id="documentos_u" name="documento">
                        </select>
                    </div>
                
                </div>
                <div class="col-md-4">
                      <div class="form-group">
                      <label for="precio_venta">Numero:</label>
                      <input type="number" class="form-control" id="num_doc_u" name="num_doc" placeholder="Ingrese Número Documento">
                    </div>
                </div>
            </div>
		 <div class="form-group">
          <label for="observacion">Observación:</label>
          <textarea class="form-control" id="observacion_u" name="observacion" placeholder="Ingrese una observación" required></textarea>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
        <button type="button" class="btn btn-primary" id="updateBtn"> Actualizar</button>
      </div>
    </div>
  </div>
</div>




<!-- Modal para ver historial -->
<!-- Modal para ver historial -->
<div class="modal fade" id="historialModal" tabindex="-1" role="dialog" aria-labelledby="historialModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="historialModalLabel">Historial del Producto</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <!-- Aquí se cargará el historial -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal de éxito -->
<div class="modal fade" id="mensajeExitoModal" tabindex="-1" role="dialog" aria-labelledby="mensajeExitoModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="mensajeExitoModalLabel">Éxito</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        El producto se ha guardado con éxito.
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>

<!-- Modal de error -->
<div class="modal fade" id="mensajeErrorModal" tabindex="-1" role="dialog" aria-labelledby="mensajeErrorModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="mensajeErrorModalLabel">Error</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <!-- Aquí se mostrará el mensaje de error -->
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>


<!-- FIN MODALES-->
  <!-- Main Footer -->
  <footer class="main-footer">
    <!-- To the right -->
    <div class="float-right d-none d-sm-inline">
      Anything you want
    </div>
    <!-- Default to the left -->
    <strong>Footer here</strong>
  </footer>
</div>
<!-- ./wrapper -->

<!-- REQUIRED SCRIPTS -->

<!-- jQuery -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.6.0/js/bootstrap.bundle.min.js"></script>
<!-- AdminLTE App -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.1.0/js/adminlte.min.js"></script>
  <!-- Script de DataTables -->
 <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.js"></script>
  <!-- Archivo de traducción al español -->
<script src="https://cdn.datatables.net/plug-ins/1.11.5/i18n/Spanish.json"></script>
<script>
  $(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
  });
</script>

<script>
$(document).ready(function() {
    $('#tablaArmazones').DataTable({
         
        "language": {
            "sProcessing":     "Procesando...",
            "sLengthMenu":     "Mostrar _MENU_ registros",
            "sZeroRecords":    "No se encontraron resultados",
            "sEmptyTable":     "Ningún dato disponible en esta tabla",
            "sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
            "sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0 registros",
            "sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
            "sInfoPostFix":    "",
            "sSearch":         "Buscar:",
            "sUrl":            "",
            "sInfoThousands":  ",",
            "sLoadingRecords": "Cargando...",
            "oPaginate": {
                "sFirst":    "Primero",
                "sLast":     "Último",
                "sNext":     "Siguiente",
                "sPrevious": "Anterior"
            },
            "oAria": {
                "sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
                "sSortDescending": ": Activar para ordenar la columna de manera descendente"
            },
            "buttons": {
                "copy": "Copiar",
                "colvis": "Visibilidad"
            }
        }
    });
});


</script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.2/xlsx.full.min.js"></script>
<script>
  document.getElementById('exportToExcel').addEventListener('click', function() {
    // Desactivar la paginación temporalmente
    var dataTable = $('#tablaArmazones').DataTable();
    dataTable.page.len(-1).draw();

    // Obtén todos los datos de la tabla
    var table = document.getElementById('tablaArmazones');
    var tableData = [];
    for (var i = 0, row; row = table.rows[i]; i++) {
        var rowData = [];
        for (var j = 0, col; col = row.cells[j]; j++) {
            rowData.push(col.innerText);
        }
        tableData.push(rowData);
    }

    // Exporta todos los datos a Excel
    var wb = XLSX.utils.book_new();
    var ws = XLSX.utils.aoa_to_sheet(tableData);
    XLSX.utils.book_append_sheet(wb, ws, 'Armazones');
    XLSX.writeFile(wb, 'armazones.xlsx');

    // Restaurar la paginación original
    dataTable.page.len(10).draw(); // Aquí asumimos que la paginación original es de 10 filas por página
});

</script>
<script>
// MODAL NUEVO PRODUCTO
    $('#nuevoModal').on('show.bs.modal', function (e) {
        // Limpiar los campos del formulario
        $(this).find('input, textarea, select').val('').end();
         $.ajax({
            url: 'includes/obtener_categorias.php', // Ruta del archivo PHP que obtiene las categorías desde la base de datos
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                // Limpiar el select de categorías
                $('#categoria_n').empty();
                // Llenar el select de categorías con los datos obtenidos
                $.each(data, function(index, categoria) {
                    $('#categoria_n').append($('<option>', {
                        value: categoria.id,
                        text: categoria.descripcion
                    }));
                });
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.log('Error al obtener las categorías: ' + errorThrown);
            }
        });
  
    $.ajax({
            url: 'includes/obtener_tipos.php', // Ruta del archivo PHP que obtiene las categorías desde la base de datos
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                // Limpiar el select de tipos
                $('#tipos_n').empty();
                // Llenar el select de tipos con los datos obtenidos
                $.each(data, function(index, tipo) {
                    $('#tipos_n').append($('<option>', {
                        value: tipo.id,
                        text: tipo.descripcion
                    }));
                });
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.log('Error al obtener los tipos: ' + errorThrown);
            }
        });
        $.ajax({
            url: 'includes/obtener_marcas.php', // Ruta del archivo PHP que obtiene las marcas desde la base de datos
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                // Limpiar el select de tipos
                $('#marcas_n').empty();
                // Llenar el select de tipos con los datos obtenidos
                $.each(data, function(index, marca) {
                    $('#marcas_n').append($('<option>', {
                        value: marca.id,
                        text: marca.descripcion
                    }));
                });
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.log('Error al obtener las marcas: ' + errorThrown);
            }
        });
        $.ajax({
            url: 'includes/obtener_estilos.php', // Ruta del archivo PHP que obtiene las marcas desde la base de datos
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                // Limpiar el select de tipos
                $('#estilos_n').empty();
                // Llenar el select de tipos con los datos obtenidos
                $.each(data, function(index, estilo) {
                    $('#estilos_n').append($('<option>', {
                        value: estilo.id,
                        text: estilo.descripcion
                    }));
                });
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.log('Error al obtener las marcas: ' + errorThrown);
            }
        });
        $.ajax({
            url: 'includes/obtener_materiales.php', // Ruta del archivo PHP que obtiene las marcas desde la base de datos
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                // Limpiar el select de tipos
                $('#materiales_n').empty();
                // Llenar el select de tipos con los datos obtenidos
                $.each(data, function(index, material) {
                    $('#materiales_n').append($('<option>', {
                        value: material.id,
                        text: material.descripcion
                    }));
                });
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.log('Error al obtener las marcas: ' + errorThrown);
            }
        });
        $.ajax({
            url: 'includes/obtener_colores.php', // Ruta del archivo PHP que obtiene las marcas desde la base de datos
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                // Limpiar el select de tipos
                $('#color_n').empty();
                // Llenar el select de tipos con los datos obtenidos
                $.each(data, function(index, color) {
                    $('#color_n').append($('<option>', {
                        value: color.id,
                        text: color.descripcion
                    }));
                });
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.log('Error al obtener las marcas: ' + errorThrown);
            }
        });
        $.ajax({
            url: 'includes/obtener_documentos.php', // Ruta del archivo PHP que obtiene las marcas desde la base de datos
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                // Limpiar el select de tipos
                $('#documentos_n').empty();
                // Llenar el select de tipos con los datos obtenidos
                $.each(data, function(index, documento) {
                    $('#documentos_n').append($('<option>', {
                        value: documento.id,
                        text: documento.descripcion
                    }));
                });
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.log('Error al obtener las marcas: ' + errorThrown);
            }
        });
        
        $('#guardarBtn').click(function() {
        // Obtener los valores de los campos del formulario
        console.log('guardar button');
        var codigo = $('#codigo_n').val();
        var cantidad = $('#cantidad_n').val();
        var tipo = $('#tipos_n').val();
        var color = $('#color_n').val();
        var categoria = $('#categoria_n').val();
        var marca = $('#marcas_n').val();
        var estilo = $('#estilos_n').val();
        var medidas = $('#medidas_n').val();
        var modelo = $('#modelo_n').val();
        var material = $('#materiales_n').val();
        var precioCompra = $('#precio_compra_n').val();
        var proveedor = $('#proveedor_n').val();
        var documento = $('#documentos_n').val();
        var precioVenta = $('#precio_venta_n').val();
        var numDocumento = $('#num_doc_n').val();
        var observacion = $('#observacion_n').val();

        // Realizar la solicitud AJAX
        $.ajax({
            url: 'includes/guardar_producto.php', // Ruta del archivo PHP que manejará la solicitud de guardado
            type: 'POST',
            dataType: 'json',
            data: {
                codigo: codigo,
                cantidad: cantidad,
                tipo: tipo,
                color: color,
                categoria: categoria,
                marca: marca,
                estilo: estilo,
                medidas: medidas,
                modelo: modelo,
                material: material,
                precioCompra: precioCompra,
                proveedor: proveedor,
                documento: documento,
                precioVenta: precioVenta,
                numDocumento: numDocumento,
                observacion: observacion
            },
            success: function(response) {
                if (response.success) {
                    // Si la respuesta es éxito, mostrar un nuevo modal con el mensaje de éxito
                    $('#nuevoModal').modal('hide');
                    $('#mensajeExitoModal').modal('show');
                    // Recargar la página después de 2 segundos (opcional)
                    setTimeout(function() {
                        location.reload();
                    }, 2000);
                } else {
                    // Si la respuesta es un error, mostrar un modal con el mensaje de error
                    //$('#nuevoModal').modal('hide');
                    $('#mensajeErrorModal').find('.modal-body').text(response.message);
                    $('#mensajeErrorModal').modal('show');
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.log('Error al guardar el producto: ' + errorThrown);
            }
        });
    });
       
    });
    // FIN MODAL NUEVO PRODUCTO
 
     //MODAL MODIFICAR PRODUCTO
    
 $('#editarModal').on('show.bs.modal', function (e) {
     var boton = $(e.relatedTarget); 
     console.log(boton.data('marca'));
        // Limpiar los campos del formulario
        $(this).find('input, textarea, select').val('').end();
        $('#registro_id').val(boton.data('id')); 
         $('#codigo_u').val(boton.data('codigo'));
         $('#modelo_u').val(boton.data('modelo'));
         $('#medidas_u').val(boton.data('medidas'));
         $('#precio_compra_u').val(boton.data('precio_compra'));
         $('#precio_venta_u').val(boton.data('precio_venta'));
         $('#proveedor_u').val(boton.data('proveedor'));
         $('#num_doc_u').val(boton.data('num_documento'));
         $('#observacion_u').val(boton.data('observacion'));
         //$sql = "SELECT p.codigo, t.descripcion as tipo, c.descripcion AS color, cat.descripcion AS categoria, m.descripcion AS marca, e.descripcion AS estilo, p.medidas, p.modelo, mat.descripcion AS material, p.precio_compra, p.proveedor, d.tipo_documento AS documento, p.precio_venta, p.num_documento, p.observacion
         
         
         
         
         
         $.ajax({
            url: 'includes/obtener_categorias.php', // Ruta del archivo PHP que obtiene las categorías desde la base de datos
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                // Limpiar el select de categorías
                $('#categoria_u').empty();
                // Llenar el select de categorías con los datos obtenidos
                $.each(data, function(index, categoria) {
                    $('#categoria_u').append($('<option>', {
                        value: categoria.id,
                        text: categoria.descripcion,
                        selected: categoria.descripcion == boton.data('categoria') // Seleccionar si coincide con el estilo del botón
                    }));
                });
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.log('Error al obtener las categorías: ' + errorThrown);
            }
        });
  
    $.ajax({
            url: 'includes/obtener_tipos.php', // Ruta del archivo PHP que obtiene las categorías desde la base de datos
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                // Limpiar el select de tipos
                $('#tipos_u').empty();
                // Llenar el select de tipos con los datos obtenidos
                $.each(data, function(index, tipo) {
                    $('#tipos_u').append($('<option>', {
                        value: tipo.id,
                        text: tipo.descripcion,
                        selected: tipo.descripcion == boton.data('tipo') // Seleccionar si coincide con el estilo del botón
                        
                    }));
                });
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.log('Error al obtener los tipos: ' + errorThrown);
            }
        });
        $.ajax({
            url: 'includes/obtener_marcas.php', // Ruta del archivo PHP que obtiene las marcas desde la base de datos
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                // Limpiar el select de tipos
                $('#marcas_u').empty();
                // Llenar el select de tipos con los datos obtenidos
                $.each(data, function(index, marca) {
                    $('#marcas_u').append($('<option>', {
                        value: marca.id,
                        text: marca.descripcion,
                        selected: marca.descripcion == boton.data('marca') // Seleccionar si coincide con el estilo del botón
                    }));
                });
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.log('Error al obtener las marcas: ' + errorThrown);
            }
        });
        $.ajax({
            url: 'includes/obtener_estilos.php', // Ruta del archivo PHP que obtiene las marcas desde la base de datos
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                // Limpiar el select de tipos
                $('#estilos_u').empty();
                // Llenar el select de tipos con los datos obtenidos
                $.each(data, function(index, estilo) {
                    $('#estilos_u').append($('<option>', {
                        value: estilo.id,
                        text: estilo.descripcion,
                        selected: estilo.descripcion == boton.data('estilo') // Seleccionar si coincide con el estilo del botón
                    }));
                });
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.log('Error al obtener las marcas: ' + errorThrown);
            }
        });
        $.ajax({
            url: 'includes/obtener_materiales.php', // Ruta del archivo PHP que obtiene las marcas desde la base de datos
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                // Limpiar el select de tipos
                $('#materiales_u').empty();
                // Llenar el select de tipos con los datos obtenidos
                $.each(data, function(index, material) {
                    $('#materiales_u').append($('<option>', {
                        value: material.id,
                        text: material.descripcion,
                        selected: material.descripcion == boton.data('material') // Seleccionar si coincide con el estilo del botón
                    }));
                });
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.log('Error al obtener las marcas: ' + errorThrown);
            }
        });
        $.ajax({
            url: 'includes/obtener_colores.php', // Ruta del archivo PHP que obtiene las marcas desde la base de datos
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                // Limpiar el select de tipos
                $('#color_u').empty();
                // Llenar el select de tipos con los datos obtenidos
                $.each(data, function(index, color) {
                    $('#color_u').append($('<option>', {
                        value: color.id,
                        text: color.descripcion,
                         selected: color.descripcion == boton.data('color') // Seleccionar si coincide con el estilo del botón
                    }));
                    
                   
                });
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.log('Error al obtener las marcas: ' + errorThrown);
            }
        });
        $.ajax({
            url: 'includes/obtener_documentos.php', // Ruta del archivo PHP que obtiene las marcas desde la base de datos
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                // Limpiar el select de tipos
                $('#documentos_u').empty();
                // Llenar el select de tipos con los datos obtenidos
                $.each(data, function(index, documento) {
                    $('#documentos_u').append($('<option>', {
                        value: documento.id,
                        text: documento.descripcion,
                        selected: documento.descripcion == boton.data('documento') // Seleccionar si coincide con el estilo del botón
                    }));
                });
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.log('Error al obtener las marcas: ' + errorThrown);
            }
        });
        
        $('#updateBtn').click(function() {
        // Obtener los valores de los campos del formulario
        
        var id = $('#registro_id').val();
        var codigo = $('#codigo_u').val();
        var tipo = $('#tipos_u').val();
        var color = $('#color_u').val();
        var categoria = $('#categoria_u').val();
        var marca = $('#marcas_u').val();
        var estilo = $('#estilos_u').val();
        var medidas = $('#medidas_u').val();
        var modelo = $('#modelo_u').val();
        var material = $('#materiales_u').val();
        var precioCompra = $('#precio_compra_u').val();
        var proveedor = $('#proveedor_u').val();
        var documento = $('#documentos_u').val();
        var precioVenta = $('#precio_venta_u').val();
        var numDocumento = $('#num_doc_u').val();
        var observacion = $('#observacion_u').val();
         console.log(id);
            // Realizar la solicitud AJAX
        $.ajax({
            url: 'includes/update_producto.php', // Ruta del archivo PHP que manejará la solicitud de guardado
            type: 'POST',
            dataType: 'json',
            data: {
                codigo: id,
                tipo_id: tipo,
                color_id: color,
                categoria_id: categoria,
                marca_id: marca,
                estilo_id: estilo,
                medidas: medidas,
                modelo: modelo,
                material_id: material,
                precio_compra: precioCompra,
                proveedor: proveedor,
                documento_id: documento,
                precio_venta: precioVenta,
                num_documento: numDocumento,
                observacion: observacion
            },
            success: function(response) {
                console.log(response.changes);
                if (response.success) {
                    // Si la respuesta es éxito, mostrar un nuevo modal con el mensaje de éxito
                    $('#nuevoModal').modal('hide');
                    $('#mensajeExitoModal').modal('show');
                    // Recargar la página después de 2 segundos (opcional)
                    setTimeout(function() {
                        location.reload();
                    }, 1000);
                } else {
                    // Si la respuesta es un error, mostrar un modal con el mensaje de error
                    //$('#nuevoModal').modal('hide');
                    $('#mensajeErrorModal').find('.modal-body').text(response.message);
                    $('#mensajeErrorModal').modal('show');
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                 
                console.log('Error al actualizar el producto: ' + errorThrown);
            }
        });
    });
       
    });
    //FIN MODAL MODIFICAR
    //MODAL HISTORIAL
$('#historialModal').on('show.bs.modal', function (e) {
     var boton = $(e.relatedTarget); 
     $('#historialModal .modal-body').html('');
        // Limpiar los campos del formulario
        
        $('#registro_id').val(boton.data('id')); 
    var codigo= (boton.data('id'));
         $.ajax({
        url: 'includes/get_historial.php',
        type: 'GET',
        dataType: 'json',
        data: { codigo: codigo },
        success: function(response) {
            if (response.success) {
                var historial = response.historial;
                var modalBody = $('#historialModal .modal-body');
                modalBody.empty();

                historial.forEach(function(entry) {
                    var historialEntry = '<p><strong>' + entry.fecha + '</strong>: ' + entry.cambios + ' (Por: ' + entry.nombres + ' ' + entry.apellidos + ')</p>';
                    modalBody.append(historialEntry);
                });
            } else {
                $('#historialModal .modal-body').html('<p>' + response.message + '</p>');
            }
        },
        error: function() {
            $('#historialModal .modal-body').html('<p>Error al obtener el historial.</p>');
        }
    });

});
// FIN MODAL HISTORIAL
//MODIFICAR CANTIDAD MODAL
 $('#agregarModal').on('show.bs.modal', function (e) {
     var boton = $(e.relatedTarget); 
    // Limpiar los campos del formulario
    $('#registro_id').val(boton.data('id'));  
 });     
    //FIN MODAL modificar cantidad
  // Controlador de eventos para el cambio de opción
  document.getElementById('accion').addEventListener('change', function() {
    var accion = this.value;
    if (accion === 'disminuir') {
      document.getElementById('disminuirCantidadOption').style.display = 'block';
      document.getElementById('aumentarCantidadOption').style.display = 'none';
    } else if (accion === 'aumentar') {
      document.getElementById('disminuirCantidadOption').style.display = 'none';
      document.getElementById('aumentarCantidadOption').style.display = 'block';
    } else {
      document.getElementById('disminuirCantidadOption').style.display = 'none';
      document.getElementById('aumentarCantidadOption').style.display = 'none';
    }
    
    
    
  });
  

   
 $('#btnAgregarProducto').click(function() {
        var accion = $('#accion').val();
        //var codigo = $('#agregarModal').data('codigo'); // Suponiendo que el modal recibe el código del producto
        var codigo = $('#registro_id').val();

        if (accion === 'disminuir') {
            var cantidad = $('#cantidadDisminuir').val();
            var observacion = $('#observacionDisminuir').val();

            if (cantidad <= 0 || observacion === '') {
                alert('Por favor, complete todos los campos requeridos.');
                return;
            }

            modificarInventario(codigo, cantidad, 'disminuir', observacion);
        } else if (accion === 'aumentar') {
            var cantidad = $('#cantidadAumentar').val();
            var proveedor = $('#proveedor').val();
            var documento = $('#documento').val();
            var numero = $('#numero').val();
            var observacion = $('#observacionAumentar').val();

            if (cantidad <= 0) {
                alert('Por favor, ingrese una cantidad válida.');
                return;
            }

            modificarInventario(codigo, cantidad, 'aumentar', observacion, proveedor, documento, numero);
        } else {
            alert('Por favor, seleccione una acción.');
        }
    });

    function modificarInventario(codigo, cantidad, accion, observacion, proveedor = '', documento = '', numero = '') {
        $.ajax({
            url: 'includes/modificar_inventario.php',
            type: 'POST',
            data: {
                codigo: codigo,
                cantidad: cantidad,
                accion: accion,
                observacion: observacion,
                proveedor: proveedor,
                documento: documento,
                numero: numero
            },
            success: function(response) {
                var data = JSON.parse(response);
                if (data.success) {
                    alert('Inventario modificado exitosamente.');
                    location.reload();
                } else {
                    alert('Error al modificar el inventario: ' + data.message);
                }
            },
            error: function() {
                alert('Error al procesar la solicitud.');
            }
        });
    }

  
  
</script>
</body>
</html>
